class StoreController < ApplicationController
  
  def index
    @products = Product.salable_items
  end

  def add_to_cart
    product = Product.find(params[:id])
    @cart = find_cart
    @cart.add_product(product)
    redirect_to(:action => 'display_cart')
  rescue
    logger.error("Tentative d'accès à un produit invalide #{params[:id]}")
    redirect_to_index('Produit invalide')
  end
  
  def display_cart
    @cart = find_cart
    @items = @cart.items
    if @items.empty?
      redirect_to_index("Votre panier est actuellement vide")
    end
  end

  def empty_cart
    @cart = find_cart
    @cart.empty!
    redirect_to_index('Votre panier est maintenant vide')
  end

  #START:checkout
  def checkout
    @cart = find_cart
    @items = @cart.items
    if @items.empty?
      redirect_to_index("Il n'y a rien dans votre panier!")
    else
      @order = Order.new
    end
  end
  #END:checkout

  # called from checkout view
  #START:save_order
  def save_order
    @cart = find_cart
    @order = Order.new(params[:order])   #<label id="code.12.new.order"/>
    @order.line_items << @cart.items       #<label id="code.12.add.items"/>
    if @order.save                        #<label id="code.12.save"/>
      @cart.empty!
      redirect_to_index('Merci pour cette commande.')
    else
      render(:action => 'checkout')       #<label id="code.12.redisplay"/>
    end
  end
  #END:save_order

  private

  # Return a cart object. If we already have one cached
  # in the session, use it, otherwise create a new one 
  # and add it to the session
  def find_cart
    session[:cart] ||= Cart.new
  end

  # Set the notice if a parameter is givem, then redirect back
  # the the product listing

  def redirect_to_index(msg = nil)
    flash[:notice] = msg if msg
    redirect_to(:action => 'index')
  end

end
