class Order < ActiveRecord::Base

  has_many :line_items

  PAYMENT_TYPES = [
    [ "Chèque",          "check" ], 
    [ "Carte de crédit",    "cc"    ],
    [ "Bon de commande", "po"    ]
  ].freeze

  validates_presence_of :name, :email, :address, :pay_type

  #START:pending_shipping
  def self.pending_shipping
    find(:all, :conditions => "shipped_at is null")
  end
  #END:pending_shipping


end

