class Order < ActiveRecord::Base

  has_many :line_items

  PAYMENT_TYPES = [
    [ "Chèque",          "check" ], 
    [ "Carte de crédit",    "cc"    ],
    [ "Bon de commande", "po"    ]
  ].freeze

  validates_presence_of :name, :email, :address, :pay_type

  def self.pending_shipping
    find(:all, :conditions => "shipped_at is null")
  end

  #START:mark_as_shipped
  def mark_as_shipped
    self.shipped_at = Time.now
  end
  #END:mark_as_shipped

end

