class Cart

  attr_reader :items
  attr_reader :total_price
  
  #START:refactor
  def initialize
    empty!
  end

  #END:refactor

  # add a product to our list of items. If an item already
  # exists for that product, up the count instead
  def add_product(product)
    item = @items.find {|i| i.product_id == product.id}
    if item
      item.quantity += 1
    else
      item = LineItem.for_product(product)
      @items << item
    end
    @total_price += product.price
  end

  #START:refactor
  #START:empty
  def empty!
    @items = []
    @total_price = 0.0
  end
  #END:empty
  #END:refactor
end

