#START:val1
#START:val2
class Product < ActiveRecord::Base

#END:val2
  validates_presence_of :title
  validates_presence_of :description
  validates_presence_of :image_url
#END:val1
#START:val2
  validates_numericality_of :price
#END:val2
#START:val3
  validates_uniqueness_of :title
#END:val3
#START:val4
  validates_format_of :image_url, 
                      :with    => %r{^http:.+\.(gif|jpg|png)$}i,
                      :message => "doit être un URL sur une image GIF, JPG, ou PNG"
#END:val4

#START:val2
  
  protected

  def validate
    errors.add(:price, "doit être supérieur à zéro") unless price.nil? || price > 0.0
  end

#START:val1
end
#END:val2
#END:val1
