class Product < ActiveRecord::Base

  validates_presence_of :title
  validates_presence_of :description
  validates_presence_of :image_url
  validates_uniqueness_of :title
  validates_numericality_of :price
  validates_format_of :image_url, 
                      :with    => %r{^http:.+\.(gif|jpg|png)$}i,
                      :message => "doit être un URL sur une image GIF, JPG, ou PNG"

  #START:salable
  # Return a list of products we can sell (which means they have to be
  # available). Show the most recently available first.
  def self.salable_items
    find(:all,
         :conditions => "date_available <= now()", 
         :order      => "date_available desc")
  end
  #END:salable

  protected

  def validate
    errors.add(:price, "doit être supérieur à zéro") unless price.nil? || price > 0.0
  end

end

