# Filters added to this controller will be run for all controllers in the application.
# Likewise, all the methods added will be available for all controllers.
class ApplicationController < ActionController::Base
  
  model :cart
  model :line_item

  private

  # Set the notice if a parameter is given, then redirect back
  # to the current controller's +index+ action
  def redirect_to_index(msg = nil)         #:doc:
    flash[:notice] = msg if msg
    redirect_to(:action => 'index')
  end

  # The #authorize method is used as a <tt>before_hook</tt> in
  # controllers that contain administration actions. If the
  # session does not contain a valid user, the method
  # redirects to the LoginController.login.
  def authorize                            #:doc:
    unless session[:user_id]
      flash[:notice] = "Veuillez vous connecter"
      redirect_to(:controller => "login", :action => "login")
    end
  end
  
end