# Une commande contient les détails concernant l'acheteur
# et une série d'articles (enregitrements LineItem)
class Order < ActiveRecord::Base

  has_many :line_items

  # Une liste des modes de paiement acceptés. La clé est le 
  # texte affiché dans la boite de sélection et la valeur est 
  # la chaine de caractères stockée dans la base de données.
  PAYMENT_TYPES = [
    [ "Chèque",          "check" ], 
    [ "Carte de crédit",    "cc"    ],
    [ "Bon de commande", "po"    ]
  ].freeze

  validates_presence_of :name, :email, :address, :pay_type
  
  # Renvoie le nombre de commandes en attente d'expédition.
  def self.count_pending
    count("shipped_at is null")
  end

  # Renvoie les commandes en attente d'expédition.
  def self.pending_shipping
    find(:all, :conditions => "shipped_at is null")
  end


  # La colonne shipped_at column est +NULL+ pour toutes les
  # commandes non expédiées, sinon elle contient la date
  # d'éxpédition
  def mark_as_shipped
    self.shipped_at = Time.now
  end
end
