# Un produit est quelque chose que l'on peut vendre
# (mais seulement si après la date +date_available+)
class Product < ActiveRecord::Base

  validates_presence_of     :title
  validates_presence_of     :description
  validates_presence_of     :image_url
  validates_uniqueness_of   :title
  validates_numericality_of :price
  validates_format_of       :image_url, 
                            :with    => %r{^http:.+\.(gif|jpg|png)$}i,
                            :message => "doit être un URL sur une image GIF, JPG, ou PNG"

  # Renvoie une liste de produits disponible à la vente. Montrer les
  # plus récents en premier.
  def self.salable_items
    find(:all,
         :conditions => "date_available <= now()", 
         :order      => "date_available desc")
  end

  protected

  # Valide que le prix est un nombre flottant positif.
  def validate  #:doc:
    errors.add(:price, "doit être supérieur à zéro") unless price.nil? || price > 0.0
  end

end

