require "digest/sha1"

# La notion d'utilisateur est nécessaire pour accéder aux tâches
# administratives. La classe est rendue un peu difficile par le fait
# que l'application traite les mots de passe en clair et que la base
# de données les stocke sous forme encryptée avec la méthode 
# de hash SHA1.

class User < ActiveRecord::Base

  # Le mot de passe en clair qui n'est pas stocké dans
  # la base de données
  attr_accessor :password

  # Le mot de passe crypté ne peut pas être defini
  # depuis un formulaire
  attr_accessible :name, :password

  validates_uniqueness_of :name
  validates_presence_of   :name, :password


  # Renvoie l'objet User correspondant au nom et au
  # mot de passe en clair spécifiés
  def self.login(name, password)
    hashed_password = hash_password(password || "")
STDERR.puts hashed_password
    find(:first,
         :conditions => ["name = ? and hashed_password = ?", 
                          name, hashed_password])
  end

  # Se connecte si le nom d'utilisateur et le mot de passe 
  # (après encryptage) correspondent à ceux de la base 
  # de données ou bien si le nom correspond à une entrée
  # sans mot de passe
  def try_to_login
    User.login(self.name, self.password)
  end

  # Quand un utilisateur est créé, son mot de passe est 
  # initialement en clair. On le crypte avec la méthode SHA1
  # avant de le sauvegarder dans la base de données.
  def before_create
    self.hashed_password = User.hash_password(self.password)
  end

  before_destroy :dont_destroy_dave

  # Ne pas détruire l'utilisateur 'dave' de la base de données
  def dont_destroy_dave
    raise "dave ne peut être détruit" if self.name == 'dave'
  end

  # Efface le mot de passe en clair une fois l'enregistrement
  # créé dans la base de données. Celà évite qu'il continue à 
  # figurer en clair dans les données de session.
  def after_create
    @password = nil
  end

  private

  def self.hash_password(password)
    Digest::SHA1.hexdigest(password)
  end
end

