# A Product is something we can sell (but only if
# we're past its +date_available+ attribute).
class Product < ActiveRecord::Base

  validates_presence_of     :title
  validates_presence_of     :description
  validates_presence_of     :image_url
  validates_uniqueness_of   :title
  validates_numericality_of :price
  validates_format_of       :image_url, 
                            :with    => %r{^http:.+\.(gif|jpg|png)$}i,
                            :message => "doit être un URL sur une image GIF, JPG, ou PNG"

  # Return a list of products we can sell (which means they have to be
  # available). Show the most recently available first.
#START:salable_items
  def self.salable_items
    find(:all,
         :conditions => "date_available <= now()", 
         :order      => "date_available desc")
  end
#END:salable_items

#START:salable?
  def salable?
    self.date_available <= Time.now
  end
#END:salable?

  protected

  # Validate that the product price is a positive Float.
  def validate  #:doc:
    errors.add(:price, "doit être supérieur à zéro") unless price.nil? || price > 0.0
  end
  
  def self.search(query)
    find_all("title like '%#{query}%'", "date_available desc")
  end

end

