#START:original
require File.dirname(__FILE__) + '/../test_helper'
require 'login_controller'

# Lever  nouveau l'exception intercepte par le contrleur
class LoginController; def rescue_action(e) raise e end; end

class LoginControllerTest < Test::Unit::TestCase
  
#END:original
#START:fixture
  fixtures :users
#END:fixture  
#START:original
  def setup
    @controller = LoginController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new
  end

  # A remplacer par votre vrtable test
  def test_truth
    assert true
  end
#END:original

# Ce test ne passera pas!
#START:index
  def test_index    
    get :index
    assert_response :success
  end
#END:index

#START:index_without_user
  def test_index_without_user
    get :index
    assert_redirected_to :action => "login"
    assert_equal "Veuillez vous connecter", flash[:notice]
  end
#END:index_without_user

#START:login_with_invalid_user
  def test_login_with_invalid_user
    post :login, :user => {:name => 'fred', :password => 'opensesame'}
    assert_response :success
    assert_equal "Nom d'utilisateur ou mot de passe invalide", flash[:notice]
  end
#END:login_with_invalid_user

#START:login_with_valid_user
  def test_login_with_valid_user
    post :login, :user => {:name => 'fred', :password => 'abracadabra'}
    assert_redirected_to :action => "index"
    assert_not_nil(session[:user_id])
    user = User.find(session[:user_id])
    assert_equal 'fred', user.name
  end
#END:login_with_valid_user
  
def test_login_with_valid_user_custom
  login
end

#START:original
end
#END:original
