ENV["RAILS_ENV"] = "test"
require File.expand_path(File.dirname(__FILE__) + "/../config/environment")
require 'test_help'

class Test::Unit::TestCase
  # Turn off transactional fixtures if you're working with MyISAM tables in MySQL
  self.use_transactional_fixtures = false #LJ was true in 1.0
  
  # Instantiated fixtures are slow, but give you @david where you otherwise would need people(:david)
  self.use_instantiated_fixtures  = true #LJ was false in 1.0

  # Add more helper methods to be used by all tests here...
end

#START:assert_salable
def assert_salable(product)
  assert(product.salable?, 
         "Le produit #{product.id} (#{product.title}) devrait tre disponible  la vente")
end
 
def assert_not_salable(product)
  assert(!product.salable?, 
         "Le produit #{product.id} (#{product.title}) ne devrait pas tre disponible  la vente")
end
#END:assert_salable

#START:assert_errors
def assert_errors
  assert_tag error_message_field
end
 
def assert_no_errors
  assert_no_tag error_message_field
end
 
def error_message_field
  {:tag => "div", :attributes => { :class => "fieldWithErrors" }}
end 
#END:assert_errors

#START:assert_login
def login(name='fred', password='abracadabra')
  post :login, :user => {:name => name, :password => password}
  assert_redirected_to :action => "index"
  assert_not_nil(session[:user_id])
  user = User.find(session[:user_id])
  assert_equal name, user.name, "Le nom de login devrait correspondre au nom de la session"
end
#END:assert_login
