require File.dirname(__FILE__) + '/../test_helper'

class CartTest < Test::Unit::TestCase

  fixtures :products

#START:setup
  def setup
    @cart = Cart.new
  end
#END:setup

  def test_add_unique_products
    @cart.add_product @version_control_book
    @cart.add_product @automation_book
    assert_equal @version_control_book.price + @automation_book.price,
                 @cart.total_price
    assert_equal 2, @cart.items.size
  end

  def test_add_duplicate_product
    @cart.add_product @version_control_book
    @cart.add_product @version_control_book
    assert_equal 2*@version_control_book.price, @cart.total_price
    assert_equal 1, @cart.items.size
  end 

end
