#START:original
#START:helper
require File.dirname(__FILE__) + '/../test_helper' # <wtf linkend="wtf.require">require ...</wtf>
#END:helper

class ProductTest < Test::Unit::TestCase
#START:fixture
  fixtures :products
#END:fixture

#START:suite
  def setup
    @product = Product.find(1)
  end
#END:suite

  # Replace this with your real tests.
  def test_truth
    assert_kind_of Product,  @product
  end
  
#END:original
#START:create
  def test_create
    assert_kind_of Product, @product
    assert_equal 1, @product.id
    assert_equal "Pragmatic Version Control", @product.title
    assert_equal "How to use version control", @product.description
    assert_equal "http://.../sk_svn_small.jpg", @product.image_url
    assert_equal 29.95, @product.price
    assert_equal "2005-01-26 00:00:00", 
                 @product.date_available_before_type_cast
  end
#END:create

#START:update
  def test_update
    assert_equal 29.95, @product.price 
    @product.price = 99.99
    assert @product.save, @product.errors.full_messages.join("; ")
    @product.reload
    assert_equal 99.99, @product.price
  end
#END:update

#START:destroy
  def test_destroy
    @product.destroy
    assert_raise(ActiveRecord::RecordNotFound) { Product.find(@product.id) }  
  end
#END:destroy

#START:validate
  def test_validate
    assert_equal 29.95, @product.price
    @product.price = 0.00
    assert !@product.save
    assert_equal 1, @product.errors.count
    assert_equal "doit être supérieur à zéro", @product.errors.on(:price)
  end
#END:validate

#START:read_with_hash
  def test_read_with_hash
    assert_kind_of Product, @product
    vc_book = @products["version_control_book"]
    assert_equal vc_book["id"], @product.id
    assert_equal vc_book["title"], @product.title
    assert_equal vc_book["description"], @product.description
    assert_equal vc_book["image_url"], @product.image_url
    assert_equal vc_book["price"], @product.price
    assert_equal vc_book["date_available"], @product.date_available_before_type_cast
  end
#END:read_with_hash

#START:read_with_fixture_variable
  def test_read_with_fixture_variable
    assert_kind_of Product, @product
    assert_equal @version_control_book.id, @product.id
    assert_equal @version_control_book.title, @product.title
    assert_equal @version_control_book.description, @product.description
    assert_equal @version_control_book.image_url, @product.image_url
    assert_equal @version_control_book.price, @product.price
    assert_equal @version_control_book.date_available, @product.date_available
  end
#END:read_with_fixture_variable

#START:salable_items
  def test_salable_items
    items = Product.salable_items
    assert_equal 2, items.length
    assert items[0].date_available <= Time.now
    assert items[1].date_available <= Time.now
    assert !items.include?(@future_proof_book)
  end
#END:salable_items

#START:salable_items_using_custom
  def test_salable_items_using_custom_assert
    items = Product.salable_items
    assert_equal 2, items.length
    assert_salable items[0]
    assert_salable items[1]
    assert_not_salable @future_proof_book
  end
#END:salable_items_using_custom

#START:original  
end
#END:original  
