#START:test
require File.dirname(__FILE__) + '/../test_helper'
require 'order_mailer'

class OrderMailerTest < Test::Unit::TestCase

  def setup
    @order = Order.new(:name =>"Dave Thomas", :email => "dave@pragprog.com")
  end

  def test_confirm
    response =  OrderMailer.create_confirm(@order)
    assert_equal("Confirmation de la commande  la Boutique Pragmatique", response.subject)
    assert_equal("dave@pragprog.com", response.to[0])
    assert_match(/Dear Dave Thomas/,  response.body)
  end
#END:test

  def test_sent
    response =  OrderMailer.create_sent(@order)
    assert_equal("Commande  la Boutique Pragmatique expdie", response.subject)
    # . . .
  end

  private
  
  def encode(subject)
    ActionMailer::Base.quoted_printable(subject, CHARSET)
  end
#START:test
end
#END:test
