class FakeController
  attr_reader :controller_path
  attr_reader :name
  def initialize(name, controller_path)
    @name = name
    @controller_path = controller_path
  end
  def kind_of?(x)
    x === Class || x == FakeController
  end
  def new
  end
end

module Controllers
  module Admin
    UserController = FakeController.new("Admin::UserController", "admin/user")
    AccessController = FakeController.new "Admin::AccessController", "admin/access"
  end

  StoreController = FakeController.new("StoreController", "store")
  BlogController = FakeController.new("BlogController", "blog")
  ArticleController = FakeController.new("ArticleController", "article")
  WibbleController = FakeController.new("WibbleController", "wibble")
end

# Extend the modules with the required methods...
[Controllers, Controllers::Admin].each do |mod|
  mod.instance_eval("alias :const_available? :const_defined?")
  mod.constants.each do |k| 
    # export the modules & controller classes.
    Object.const_set(k, mod.const_get(k))
  end
end
=begin
module Controllers
  class StoreController
    def self.controller_path
      "store"
    end
  end
  class BlogController
    def self.controller_path
      "blog"
    end
  end
  class ArticleController
    def self.controller_path
      "article"
    end
  end
  class WibbleController
    def self.controller_path
      "wibble"
    end
  end
  def Controllers.const_available?(name)
    true
  end
  
  class Response
  end
end
=end

class Request
  attr_reader :path
  attr_accessor :path_parameters
  def initialize(path)
    @path=path
    @path_parameters = {}
  end
  def parameters
    {}
  end
  def cookies
    []
  end
  def session
    {}
  end
  def protocol
    "http://"
  end
  def host_with_port
    "pragprog.com:80"
  end
  def relative_url_root
    ""
  end
  def symbolized_path_parameters
    {}
  end
end

