$: << File.dirname(__FILE__)
require "connect"
require "logger"

#ActiveRecord::Base.logger = Logger.new(STDOUT)

require "rubygems"
require_gem "activerecord"


#START:product
class Product < ActiveRecord::Base
  has_many :line_items
end
#END:product

class LineItem < ActiveRecord::Base
  belongs_to :product
end

LineItem.delete_all

p = Product.create(:title => "Programming Ruby", :date_available => Time.now)
l = LineItem.new
l.id = 2
l.product = p
l.save!

l = LineItem.new
l.product = p
l.save!

#START:simple_belongs_to
item = LineItem.find(2)

# item.product est l'objet Product associ
puts "Le produit courant est #{item.product.id}"
puts item.product.title

item.product = Product.new(:title          => "Advanced Rails",
                           :description    => "...",
                           :image_url      => "http://....jpg",
                           :price          => 34.95,
                           :date_available => Time.now)
item.save!

puts "Le nouveau produit est #{item.product.id}"
puts item.product.title
#END:simple_belongs_to

#START:product_belongs_to
item = LineItem.find(2)

# item.product est l'objet Product associ
puts "Le produit courant #{item.product.id}"
puts item.product.title

item = LineItem.new()

item.create_product(:title          => "Advanced Rails", 
                    :description    => "...",
                    :image_url      => "http://....jpg",
                    :price          => 34.95,
                    :date_available => Time.now)

puts "Le nouveau produit est #{item.product.id}"
puts item.product.title
#END:product_belongs_to
item.save!
p item.product(true)

puts "============="

prod = Product.find(item.product_id)
p prod.line_items.size

