drop table if exists bools;
drop table if exists media_products;
drop table if exists customers;
drop table if exists children;
drop table if exists parents;
drop table if exists counters;
drop table if exists purchases;
drop table if exists accounts;
drop table if exists categories_products;
drop table if exists categories;
drop table if exists users;
drop table if exists line_items;
drop table if exists orders;
drop table if exists invoices;
drop table if exists refunds;
drop table if exists payments;
drop table if exists products;
drop table if exists employees;
drop table if exists people;

/*START:employee*/
create table employees (
 id              int           not null auto_increment,
 name            varchar(200)  not null,
 manager_id      int,
 mentor_id       int,
 primary key (id),
 constraint fk_manager foreign key (manager_id) references employees(id),
 constraint fk_mentor  foreign key (mentor_id)  references employees(id)
);
/*END:employee*/


/*START:show_counter*/
create table products (
 id              int           not null auto_increment,
 title           varchar(100)  not null,
 /* . . .*/
/*END:show_counter*/
 description     text          not null,
 image_url       varchar(200)  not null,
 price           decimal(10,2) not null,
 date_available  datetime      not null,
/*START:show_counter*/
 line_items_count int          default 0,
 primary key (id)
);
/*END:show_counter*/

create table payments (
 id              int           not null auto_increment,
 primary key (id)
);

create table refunds (
 id              int           not null auto_increment,
 primary key (id)
);

create table invoices (
 id              int           not null auto_increment,
 order_id        int           not null,
 constraint fk_inv_order   foreign key (order_id) references orders(id),
 primary key (id)

);

/*START:orders*/
create table orders (
 id              int           not null auto_increment,
 name            varchar(100)  not null,
 email           varchar(255)  not null,
 address         text          not null,
 pay_type        char(10)      not null,
 shipped_at	 datetime      null,
 primary key (id)
);
/*END:orders*/

create table line_items (
  id              int           not null auto_increment,
  product_id	  int 	        not null,
  order_id        int           not null,
  quantity	  int           not null default 0,
  unit_price	  float(10,2)   not null,
  constraint fk_items_product   foreign key (product_id) references products(id),
  constraint fk_items_order     foreign key (order_id) references orders(id),
  primary key (id)
);


create table users (
  id              int           not null auto_increment,
  name		  varchar(100)  not null,
  zipcode	  char(10)	not null,
  hashed_password char(40)      null,
  primary key (id)
);

/*START:categories-tree*/
create table categories (
  id              int           not null auto_increment,
  name		  varchar(100)  not null,
  parent_id	  int,
/*END:categories-tree*/
  lft		  int,
  rgt		  int,
/*START:categories-tree*/
  constraint fk_category   	foreign key (parent_id) references categories(id),
/*END:categories-tree*/
  constraint fk_lft		foreign key (lft) references categories(id),
  constraint fk_rgt		foreign key (rgt) references categories(id),
/*START:categories-tree*/
  primary key (id)
);
/*END:categories-tree*/



/*START:join*/
create table categories_products (
  category_id     int	    not null,
  product_id	  int	    not null,
  constraint fk_cp_category foreign key (category_id) references categories(id),
  constraint fk_cp_product  foreign key (product_id)  references products(id),
  primary key (category_id, product_id)
);
/*END:join*/


/*START:accounts*/
create table accounts (
  id              int           not null auto_increment,
  number	  varchar(10)   not null,
  balance	  decimal(10,2) default 0.0,
  primary key (id)
) type=InnoDB;
/*END:accounts*/

/*START:purchases*/
create table purchases (
  id              int		    not null auto_increment,
  name            varchar(100)      not null,
  last_five       text,
  primary key (id)
);            
/*END:purchases*/

/*START:counters*/
create table counters (
  id              int   not null auto_increment,
  count           int   default 0,
  lock_version    int   default 0,
  primary key (id)
);            
/*END:counters*/


/*START:parentchild*/
create table parents (
  id              int           not null auto_increment,
  primary key (id)
);

create table children (
  id              int           not null auto_increment,
  parent_id	  int 	        not null,
  name		  varchar(20),
  position	  int,
  constraint fk_parent   foreign key (parent_id) references parents(id),
  primary key (id)
);
/*END:parentchild*/

/*START:customers*/
create table customers (
  id              int           not null auto_increment,
  created_at	  datetime	not null,
  credit_limit	  decimal(10,2) default 100.0,
  first_name	  varchar(50),
  initials	  varchar(20),
  last_name	  varchar(50),
  last_purchase	  datetime,
  purchase_count  int		default 0,
  primary key (id)
);
/*END:customers*/



/*START:person*/
create table people (
  id              int           not null auto_increment,
  type		  varchar(20)	not null,
  
  /* attributs communs */
  name    	  varchar(100)	not null,
  email		  varchar(100)	not null,

  /* attributs pour type=Customer */
  balance	  decimal(10,2),

  /* attributs pour type=Employee */
  reports_to	  int,
  dept		  int,

  /* attributes pour type=Manager */
  /* -- none -- */

  constraint fk_reports_to foreign key (reports_to) references people(id),
  primary key (id)
);
/*END:person*/

/*START:bools*/
create table bools (
  id              int           not null auto_increment,
  flag	  	  bool,
  primary key (id)
);
/*END:bools*/

create table bad_books (
  isbn   varchar(50),
  title  varchar(200),
  primary key (isbn)
);


