$: << File.dirname(__FILE__)
require "connect"
require "logger"

#ActiveRecord::Base.logger = Logger.new(STDOUT)

require "rubygems"
require_gem "activerecord"

#START:employee
class Employee < ActiveRecord::Base

  belongs_to :manager,
             :class_name  => "Employee",
             :foreign_key => "manager_id"

  belongs_to :mentor,
             :class_name  => "Employee", 
             :foreign_key => "mentor_id"
  
  has_many   :mentored_employees,
             :class_name  => "Employee",
             :foreign_key => "mentor_id"

  has_many   :managed_employees,
             :class_name  => "Employee",
             :foreign_key => "manager_id"
end
#END:employee

#START:load
Employee.delete_all

clem = Employee.create(:id => 1, :name => "Clment")
eglant = Employee.create(:id => 2, :name => "Eglantine")

clem = Employee.new(:name => "Clment")
clem.manager = clem
clem.mentor  = eglant
clem.save!

gath = Employee.new(:name => "Agathe")
gath.manager = clem
gath.mentor  = clem
gath.save!
#END:load

#START:try
p clem.managed_employees.map {|e| e.name}  # => [ "Clment", "Agathe" ]
p clem.mentored_employees                  # => []

p gath.mentor.name                         # => "Clment"
#END:try


