$: << File.dirname(__FILE__)
require "connect"
require "logger"

ActiveRecord::Base.logger = Logger.new(STDOUT)

require "rubygems"
require_gem "activerecord"

#START:define
class Person < ActiveRecord::Base
end

class Customer < Person
end

class Employee < Person
end

class Manager < Employee
end
#END:define


Person.delete_all

#START:demo
Manager.create(:name => 'Bob', :email => "bob@some.add",
               :dept => 12, :reports_to => nil)

Customer.create(:name => 'Sally', :email => "sally@other.add",
                :balance => 123.45)

person = Person.find(:first)
puts person.class    #=> Manager
puts person.name     #=> Bob
puts person.dept     #=> 12

person = Person.find_by_name("Sally")
puts person.class    #=> Customer
puts person.email    #=> sally@other.add
puts person.balance  #=> 123.45
#END:demo
