class ArticleSweeper < ActionController::Caching::Sweeper

  observe Article

  # Si on cre un nouvel article, la version publique de la liste
  # des articles doit tre regnre.
  def after_create(article)
    expire_public_page
  end


  # Si un article existant est modifi, la version dans le cache
  # devient obsolte.
  def after_update(article)
    expire_article_page(article.id)
  end

  # Supprimer un article implique de mettre  jour la version
  # publique de la liste et de supprimer l'article dans le cache
  def after_destroy(article)
    expire_public_page
    expire_article_page(article.id)
  end

  private

  def expire_public_page
    expire_page(:controller => "content", :action => 'public_content')
  end

  def expire_article_page(article_id)
    expire_action(:controller => "content", 
                  :action     => "premium_content",
                  :id         => article_id)
  end

end
