class StoreController < ApplicationController

  def index
    @products = Product.salable_items
  end

  def add_to_cart
    product = Product.find(params[:id])
    @cart = find_cart
    @cart.add_product(product)
    redirect_to(:action => 'display_cart')
  rescue
    logger.error("Tentative d'accès à un produit invalide #{params[:id]}")
    redirect_to_index('Produit invalide')
  end
  
#START:display_cart
  def display_cart
    @cart = find_cart
    @items = @cart.items
    if @items.empty?
      redirect_to_index("Votre panier est actuellement vide")
    end

    if params[:context] == :checkout
      render(:layout => false)
    end
  end
#END:display_cart

  def empty_cart
    @cart = find_cart
    @cart.empty!
    redirect_to_index('Votre panier est maintenant vide')
  end

  def checkout
    @cart = find_cart
    @items = @cart.items
    if @items.empty?
      redirect_to_index("Il n'y a rien dans votre panier!")
    else
      @order = Order.new
    end
  end

  # called from checkout view
  def save_order
    @cart = find_cart
    @order = Order.new(params[:order])    #<label id="code.12.new.order"/>
    @order.line_items << @cart.items       #<label id="code.12.add.items"/>
    if @order.save                        #<label id="code.12.save"/>
      @cart.empty!
      redirect_to_index('Merci pour cette commande.')
    else
      render(:action => 'checkout')       #<label id="code.12.redisplay"/>
    end
  end

  private

  # Renvoie un objet panier. Si le panier existe déjà dans le cache 
  # alors on l'assigne à cette variable, sinon on en crée un nouveau
  # et on l'ajoute à la session
  def find_cart
    session[:cart] ||= Cart.new
  end

  # Renseigne le flash si un paramètre est transmis
  # puis redirige vers la liste des produits

  def redirect_to_index(msg = nil)
    flash[:notice] = msg if msg
    redirect_to(:action => 'index')
  end

end
