class StoreController < ApplicationController
  
  def index
    @products = Product.salable_items
  end

  #START:add_to_cart
  def add_to_cart
    product = Product.find(params[:id])
    @cart = find_cart
    @cart.add_product(product)
    redirect_to(:action => 'display_cart')
  end
  #END:add_to_cart

  #START:display_cart
  def display_cart
    @cart = find_cart
    @items = @cart.items
  end
  #END:display_cart


#START:cart  
  private
#END:cart

  # Renvoie un objet panier. Si le panier existe dj dans le cache 
  # alors on l'assigne  cette variable, sinon on en cre un nouveau
  # et on l'ajoute  la session
#START:cart
  def find_cart
    session[:cart] ||= Cart.new
  end
#END:cart

end
