class StoreController < ApplicationController
  
  def index
    @products = Product.salable_items
  end

  def add_to_cart
    product = Product.find(params[:id])
    @cart = find_cart
    @cart.add_product(product)
    redirect_to(:action => 'display_cart')
  end
  
  #START:display_cart
  def display_cart
    @cart = find_cart
    @items = @cart.items
  end
  #END_display_cart


#START:cart  
  private
#END:cart

  # Return a cart object. If we already have one cached
  # in the session, use it, otherwise create a new one 
  # and add it to the session
#START:cart
  def find_cart
    session[:cart] ||= Cart.new
  end
#END:cart

end
