class Cart

  attr_reader :items
  attr_reader :total_price
  
  def initialize
    @items = []
    @total_price = 0.0
  end

  # Ajoute un produit  la liste des articles du panier. Si l'article
  # est dj prsent, la quantit est augmente de un au lieu de
  # crer une nouvelle entre.
  #START:add_product
  def add_product(product)
    item = @items.find {|i| i.product_id == product.id}
    if item
      item.quantity += 1
    else
      item = LineItem.for_product(product)
      @items << item
    end
    @total_price += product.price
  end
  #END:add_product
end

