#START:test_add_product
require File.dirname(__FILE__) + '/../test_helper'

#START:fixture
class CartTest < Test::Unit::TestCase

#END:test_add_product
  fixtures :products
  # . . .
#END:fixture
  #START:test_add_product
  def test_add_product
    cart = Cart.new
    assert_equal(0.0, cart.total_price)
    assert_equal(0, cart.items.size)

    p1 = Product.find(1)  # $12.34
    p2 = Product.find(2)  # $23.45

    cart.add_product(p1)
    assert_equal(p1.price, cart.total_price)
    assert_equal(1, cart.items.size)

    cart.add_product(p2)
    assert_equal(p1.price + p2.price, cart.total_price)
    assert_equal(2, cart.items.size)

    # Inserting duplicate should increase price, but not item count
    cart.add_product(p1)
    assert_equal(2*p1.price + p2.price, cart.total_price)
    assert_equal(2, cart.items.size)

    cart.add_product(p2)
    assert_equal(2*p1.price + 2*p2.price, cart.total_price)
    assert_equal(2, cart.items.size)
  end
end
#END:test_add_product
