# Un panier consiste en une liste d'objets LineItem et un prix total
# actuel. L'ajout d'un produit au panier ajoutera soit une nouvelle
# entre  la liste ou incrmentera le quantit d'un article existant.
# Dans les deux cas le prix total est mis  jour.
#
# La classe Cart est un modle mais il ne stocke aucune information 
# dans la base de donnes. C'est pour cette raison qu'elle n'hrite
# pas de la classe ActiveRecord::Base.

class Cart

  # Un tableau d'objets LineItem
  attr_reader :items

  # La prix total de tout ce qui figure dans le panier
  attr_reader :total_price
  
  # Cre un nouveau panier. Le travail est en fait dlguer 
  #  #empty!
  def initialize
    empty!
  end

  # Ajoute un produit  la liste des articles du panier. Si l'article
  # est dj prsent, la quantit est augmente de un au lieu de
  # crer une nouvelle entre.
  def add_product(product)
    item = @items.find {|i| i.product_id == product.id}
    if item
      item.quantity += 1
    else
      item = LineItem.for_product(product)
      @items << item
    end
    @total_price += product.price
  end

  # Vide le panier en rinitialisant le tableau des articles
  # et en remettant  zro le montant total du panier
  def empty!
    @items = []
    @total_price = 0.0
  end
end 
