# This controller performs double duty. It contains the
# #login action, which is used to log in administrative users.
#
# It also contains the #add_user, #list_users, and #delete_user
# actions, used to maintain the users table in the database.
#
# The LoginController shares a layout with AdminController
#
# See also: User

class LoginController < ApplicationController

  layout "admin"

  # You must be logged in to use all functions except #login
#START:filter
  before_filter :authorize, :except => :login
#END:filter
  # The default action displays a status page.
  def index
    @total_orders   = Order.count
    @pending_orders = Order.count_pending
  end

  # Display the login form and wait for user to
  # enter a name and password. We then validate
  # these, adding the user object to the session
  # if they authorize. 
  def login
    if request.get?
      session[:user_id] = nil
      @user = User.new
    else
      @user = User.new(params[:user])
      logged_in_user = @user.try_to_login

      if logged_in_user
        session[:user_id] = logged_in_user.id
        redirect_to(:action => "index")
      else
        flash[:notice] = "Nom d'utilisateur ou mot de passe invalide"
      end
    end
  end
  
  # Add a new user to the database.
  def add_user
    if request.get?
      @user = User.new
    else
      @user = User.new(params[:user])
      if @user.save
        redirect_to_index("Utilisateur #{@user.name} créé")
      end
    end
  end

  # Delete the user with the given ID from the database.
  # The model raises an exception if we attempt to delete
  # the last user.
  def delete_user
    id = params[:id]
    if id && user = User.find(id)
      begin
        user.destroy
        flash[:notice] = "Utilisateur #{user.name} supprimé"
      rescue
        flash[:notice] = "Impossible de supprimer cet utilisateur"
      end
    end
    redirect_to(:action => :list_users)
  end

  # List all the users.
  def list_users
    @all_users = User.find(:all)
  end

  # Logout by clearing the user entry in the session. We then
  # redirect to the #login action.
  def logout
    session[:user_id] = nil
    flash[:notice] = "Déconnecté"
    redirect_to(:action => "login")
  end
end
