#START:original
require File.dirname(__FILE__) + '/../test_helper'
require 'search_controller'

class SearchControllerTest < Test::Unit::TestCase

  fixtures :products
  
  def setup
    @controller = SearchController.new
    @request = ActionController::TestRequest.new
    @response = ActionController::TestResponse.new
  end
#END:original

#START:tests
#START:search
  def test_search
    get :search, :query => "version control"
    assert_response :success
#END:search
#START:view
    assert_equal "1 produit(s) trouvé(s).", flash[:notice]
    assert_template "search/results"
#END:view
#START:product
    products = assigns(:products)
    assert_not_nil products
    assert_equal 1, products.size
    assert_equal "Pragmatic Version Control", products[0].title
#END:product
#START:tag
    assert_tag :tag => "div", 
               :attributes => { :class => "results" },
               :children => { :count => 1, 
                              :only => { :tag => "div", 
                                         :attributes => { :class => "catalogentry" }}}
             
#END:tag
  end
#END:tests

#START:original
end
#END:original
