#START:original
require File.dirname(__FILE__) + '/../test_helper'
require 'store_controller'

# Reraise errors caught by the controller.
class StoreController; def rescue_action(e) raise e end; end

class StoreControllerTest < Test::Unit::TestCase

  fixtures :products, :orders
  
  def setup
    @controller = StoreController.new
    @request = ActionController::TestRequest.new
    @response = ActionController::TestResponse.new
  end

  def teardown
    LineItem.delete_all
  end

#END:original

#START:index
  def test_index
    get :index
    assert_response :success
    assert_equal 2, assigns(:products).size
    assert_template "store/index"
  end
#END:index

#START:add_to_cart
  def test_add_to_cart
    get :add_to_cart, :id => @version_control_book.id
    cart = session[:cart]
    assert_equal @version_control_book.price, cart.total_price
    assert_redirected_to :action => 'display_cart'
    follow_redirect
    assert_equal 1, assigns(:items).size
    assert_template "store/display_cart"
  end
#END:add_to_cart

#START:add_to_cart_invalid_product
  def test_add_to_cart_invalid_product
    get :add_to_cart, :id => '-1'
    assert_redirected_to :action => 'index'
    assert_equal "Produit invalide", flash[:notice]
  end
#END:add_to_cart_invalid_product
  
#START:checkout
  def test_checkout
    test_add_to_cart
    get :checkout
    assert_response :success
    assert_not_nil assigns(:order)
    assert_template "store/checkout"
  end
#END:checkout

#START:save_invalid_order
  def test_save_invalid_order
    test_add_to_cart
    post :save_order, :order => {:name => 'fred', :email => nil}
    assert_response :success
    assert_template "store/checkout"
    assert_tag :tag => "div", :attributes => { :class => "fieldWithErrors" }
    assert_equal 1, session[:cart].items.size
  end
#END:save_invalid_order

#START:save_valid_order
  def test_save_valid_order
    test_add_to_cart
    assert_equal 1, session[:cart].items.size
    assert_equal 1, Order.count
    post :save_order, :order => @valid_order_for_fred.attributes
    assert_redirected_to :action => 'index'
    assert_equal "Merci pour cette commande.", flash[:notice]
    follow_redirect
    assert_template "store/index"
    assert_equal 0, session[:cart].items.size
    assert_equal 2, Order.find_all.size
  end
#END:save_valid_order
  
  def test_assert_tags_many_options
    test_add_to_cart
    get :save_order, :order => {:name => 'fred', :email => nil}
                                 
    assert_tag :tag => "html"
    assert_tag :content => "Boutique en ligne des éditions Pragprog"
    assert_tag :tag => "head", :parent => { :tag => "html" }
    assert_tag :tag => "html", :child => { :tag => "head" }
    assert_tag :tag => "div",  :ancestor => { :tag => "html" }
    assert_tag :tag => "html", :descendant => { :tag => "div" }
    assert_tag :tag => "ul",   :children => { 
                                  :count => 1..3, 
                                  :only => { :tag => "li" } }
  end

#START:original
end
#END:original
