#START:setup
require File.dirname(__FILE__) + '/../test_helper'
require 'store_controller'

class OrderTest < Test::Unit::TestCase
#END:setup

#START:setup
  fixtures :products
#END:setup

#START:setup
  HOW_MANY = 100
#END:setup

#START:setup
  def setup
    @controller = StoreController.new
    @request = ActionController::TestRequest.new
    @response = ActionController::TestResponse.new
#END:setup

#START:setup
    get :add_to_cart, :id => @version_control_book.id
  end
  
  def teardown
    Order.delete_all
  end
#END:setup

#START:test
  def test_save_bulk_orders
      
    elapsedSeconds = Benchmark::realtime do
    
      Fixtures.create_fixtures(File.dirname(__FILE__) + 
                               "/../fixtures/performance", "orders")

      assert_equal(HOW_MANY, Order.find_all.size)

      1.upto(HOW_MANY) do |id|
        order = Order.find(id)
        get :save_order, :order => order.attributes
        assert_redirected_to :action => 'index'
        assert_equal("Merci pour cette commande.", flash[:notice])
      end
    
    end
    
    assert elapsedSeconds < 8.0, "Le test a pris #{elapsedSeconds} secondes"
#END:test

#START:test
  end
#END:test
end
