require "rubygems"
require_gem "actionpack"

require 'fake_environment'



ActionController::Base.debug_routes = true

#START:blog
ActionController::Routing::Routes.draw do |map|
  # L'URL direct 'http://my.app/blog/' affiche l'index

  map.connect "blog/", 
              :controller   => "blog",
              :action       => "index"

  # Renvoie les articles pour une anne, anne/mois ou anne/mois/jour
  map.connect "blog/:year/:month/:day", 
              :controller   => "blog",
              :action       => "show_date",
              :requirements => { :year  => /(19|20)\d\d/, 
                                 :month => /[01]?\d/, 
                                 :day   => /[0-3]?\d/},
              :day          => nil,
              :month        => nil

  # Affiche un article indentifi par son id
  map.connect "blog/show/:id",
              :controller   => "blog",
              :action       => "show",
              :id           => /\d+/

  # Routage Rails classique pour les fonctions d'administration
  map.connect "blog/:controller/:action/:id"

  # Attrape tout le reste pour grer convenablement les requtes mal formes
  map.connect "*anything",
              :controller   => "blog",
              :action       => "unknown_request"

end
#END:blog
["blog",
 "blog/show/123",
 "blog/2004",
 "blog/2004/12",
 "blog/2004/12/25",
 "blog/article/edit/123",
 "blog/article/show_stats",
 "blog/wibble",
 "cochonnerie"].each do |url|
  
  puts "URL> #{url}"
  req = Request.new(url)
  params = ActionController::Routing::Routes.recognize_path(url.split('/'))
  puts "@params = " + params.inspect
end


