require "rubygems"
require_gem "actionpack"
require 'action_controller/url_rewriter'

require 'fake_environment'



ActionController::Base.debug_routes = true

#START:blog
ActionController::Routing::Routes.draw do |map|

  # L'URL direct 'http://my.app/blog/' affiche l'index
  map.index   "blog/", 
              :controller   => "blog",
              :action       => "index"

  # Renvoie les articles pour une anne, anne/mois ou anne/mois/jour
  map.date "blog/:year/:month/:day", 
              :controller   => "blog",
              :action       => "show_date",
              :requirements => { :year  => /(19|20)\d\d/, 
                                 :month => /[01]?\d/, 
                                 :day   => /[0-3]?\d/},
              :day          => nil,
              :month        => nil

  # Affiche un article indentifi par son id
  map.show "blog/show/:id",
              :controller   => "blog",
              :action       => "show",
              :id           => /\d+/
  # Routage Rails classique pour les fonctions d'administration
  map.admin "blog/:controller/:action/:id"

  # Attrape tout le reste pour grer convenablement les requtes mal formes
  map.catchall "*anything",
               :controller   => "blog",
               :action       => "unknown_request"

end
#END:blog
["blog",
 "blog/show/123",
 "blog/2004",
 "blog/2004/12",
 "blog/2004/12/25",
 "blog/article/edit/123",
 "blog/article/show_stats",
 "blog/wibble",
 "cochonnerie"].each do |url|
  
  puts "URL> #{url}"
  params = ActionController::Routing::Routes.recognize_path(url.split('/'))
  puts "@params = " + (params.map do |key, value|
    if value.kind_of?(FakeController)
      "#{key} => #{value.name}"
    else
      "#{key} => #{value}"
    end
  end).join(", ")
end

url = ActionController::UrlRewriter.new(Request.new("http://pragprog.com/blog"), {})

puts url.rewrite(:controller => "blog", "action" => "edit", :id => 1)


class ActionController::Base

  def dump_routes
    ActionController::Routing::NamedRoutes.install
    p index_url
  end
end

b = ActionController::Base.new
b.dump_routes

