module TestHelper
  def show(xml, str)
    res = eval(str)
    xml.dt(:newline => "yes") do
      xml.inlinecode("<%= " + str + " %>")
    end
    xml.dd do
      xml.p(res)
    end
  end

#START:postage
  ShippingOption = Struct.new(:id, :name)

  class ShippingType
    attr_reader :type_name, :options
    def initialize(name)
      @type_name = name
      @options = []
    end
    def <<(option)
      @options << option
    end
  end
  
  ground    = ShippingType.new("LENT")
  ground   << ShippingOption.new(100, "Courier Par Route")
  ground   << ShippingOption.new(101, "Courier Media")
  
  regular   = ShippingType.new("NORMAL")
  regular  << ShippingOption.new(200, "Air Courrier")
  regular  << ShippingOption.new(201, "Courier Certifi")
  
  priority  = ShippingType.new("RAPIDE")
  priority << ShippingOption.new(300, "Prioritaire")
  priority << ShippingOption.new(301, "Express")
  
  SHIPPING_OPTIONS = [ ground, regular, priority ]
#END:postage  
end
