class ExampleController < ApplicationController  
   
  # START:say_hello
  def say_hello
    render(:layout => false)
  end
  # END:say_hello
  
  # START:multiple
  def multiple
  end

  def update_many
    render(:layout => false)
  end
  # END:multiple
  
  def destroy
    # nothing to do here, just for show
    render(:nothing => true)
  end
  
  # START:periodic
  def periodic
    # No action...
  end

  # Return a process listing (Unix specific code)
  def ps
    render(:text => "<pre>" + CGI::escapeHTML(`ps -a`) + "</pre>")
  end
  # END:periodic
  
  
  # START:observer1
  WORDLIST = %w(Rails est un framework web open source complet crit en Ruby
    qui permet de concevoir des applications relles avec bonne humeur et
    moins de code que les autres frameworks utilisant XML)
  #END:observer1
    
  # START:observer2
  def search
    @phrase  = request.raw_post || request.query_string
    matcher  = Regexp.new(@phrase)
    @results = WORDLIST.find_all { |word| word =~ matcher }
    render(:layout => false)
  end
  # END:observer2


  # START:xhr
  def checkxhr
    if request.xhr?
      render(:text => "Style Ajax du 21me sicle.", :layout => false)
    else
      render(:text => "Le bon vieux web.")
    end 
  end
  # END:xhr
  
  def faulty_xhr
  end
  
  # START:faulty
  def faulty
    a = 1 / 0    # lve l'exception ZeroDivisionError
    rescue Exception => e
      if request.xhr? 
        @errormessage = "Erreur: #{e.message} in #{e.backtrace.first}"
        render(:template => "alert('<%= escape_javascript(@errormessage) %>');", :layout => false)
      else
        raise    # les appels non-ajax devrait utiliser la page d'erreur Rails
      end
  end
  # END:faulty
  
  def compat
  end

  def compat_form
  end

  def effectswithoutajax
  end

   
end
