//Standard PWM DC control
int E1 = 5;     //Contrôle de vitesse du moteur M1
int E2 = 6;     //Contrôle de vitesse du moteur M2
int M1 = 4;    //Contrôle du sens de rotation du moteur M1
int M2 = 7;    //Contrôle du sens de rotation du moteur M2

///Pour la carte Romeo plus ancienne, utilisez ces broches.
//int E1 = 6;     //Contrôle de vitesse du moteur M1
//int E2 = 9;     //Contrôle de vitesse du moteur M2
//int M1 = 7;    //Contrôle du sens de rotation du moteur M1
//int M2 = 8;    //Contrôle du sens de rotation du moteur M2


void stop(void)                    //Stop
{
  digitalWrite(E1,LOW);   
  digitalWrite(E2,LOW);      
}   
void advance(char a,char b)          //Déplacement avant
{
  analogWrite (E1,a);      //Contrôle de vitesse PWM
  digitalWrite(M1,HIGH);    
  analogWrite (E2,b);    
  digitalWrite(M2,HIGH);
}  
void back_off (char a,char b)          //Déplacement arrière
{
  analogWrite (E1,a);
  digitalWrite(M1,LOW);   
  analogWrite (E2,b);    
  digitalWrite(M2,LOW);
}
void turn_L (char a,char b)             //Tourner à gauche
{
  analogWrite (E1,a);
  digitalWrite(M1,LOW);    
  analogWrite (E2,b);    
  digitalWrite(M2,HIGH);
}
void turn_R (char a,char b)             //Tourner à droite
{
  analogWrite (E1,a);
  digitalWrite(M1,HIGH);    
  analogWrite (E2,b);    
  digitalWrite(M2,LOW);
}
void setup(void) 
{ 
  int i;
  for(i=4;i<=7;i++)
    pinMode(i, OUTPUT);  
  Serial.begin(115200 );      //Vitesse de communication
  while(!Serial);
  Serial.println("Controle par le clavier");
    digitalWrite(13,HIGH);   

} 
void loop(void) 
{
  if(Serial.available()){
    char val = Serial.read();
    if(val != -1)
    {
      Serial.println(val);
      switch(val)
      {
      case 'U'://Déplacement avant
        advance (255,255);   //Déplacement avant à la vitesse maximale
        break;
      case 'D'://Déplacement arrière
        back_off (255,255);   //Déplacement arrière à la vitesse maximale
        break;
      case 'L'://Tourner à gauche
        turn_L (255,255);
        break;       
      case 'R'://Tourner à droite
        turn_R (255,255);
        break;
      case 'S':
        stop();
        break;
      }
    }
    else stop();  
  }
}
