	  /* fichier chaine.h : dclaration de la classe chaine */

#include <string.h>

#include <iostream>  // voir N.B. du paragraphe "nouvelles possibilits

                     // d'entres-sorties du chapitre II

using namespace std ;

class chaine

{ int lg ;                // longueur actuelle de la chane

  char * adr ;                 // adresse zone contenant la chane

 public :

  chaine () ;                  // constructeur I

  chaine (char *) ;            // constructeur II

  chaine (chaine &) ;    // constructeur III (par recopie) 

  ~chaine ()                   // destructeur ("inline")

    { delete adr ;

    }

  chaine & operator = (const chaine &) ;      // oprateur d'affectation 

  long length ()          // longueur courante ("inline")

    { return lg ;

    }

  int operator == (chaine &) ;

  char & operator [] (int) ;

  friend chaine operator + (const chaine &, const chaine &) ;

  friend ostream & operator << (ostream &, chaine &) ;

} ;









	 /* dfinitions des fonctions membre de la classe chaine */

#include "chaine.h"

#include <string.h>

chaine::chaine ()               // constructeur I

{  lg = 0 ; adr=new char[1] ; adr[0] = 0 ;

}

chaine::chaine (char * adc)     // constructeur II ( partir d'une chane C)

   { lg = strlen (adc) ;

     adr = new char [lg+1]  ;

     strcpy (adr, adc) ;

   }

chaine::chaine (chaine & ch)    // constructeur III (par recopie)

   { lg = ch.lg ;

     adr = new char [lg+1] ;

     strcpy (adr, ch.adr) ;

   }

chaine & chaine::operator = (const chaine & ch) // oprateur d'affectation

   { if (this != & ch)                  // on ne fait rien pour a=a

       { delete adr ;

         lg = ch.lg ;

         adr = new char [lg+1] ;

         strcpy (adr, ch.adr) ;

       }

     return * this ;             // pour pouvoir utiliser 

   }                             // la valeur de a=b (affectations multiples)

int chaine::operator == (chaine & ch)

   { if (strcmp (adr, ch.adr) ) return 0 ;

                           else return 1 ;

   }

char & chaine::operator [] (int i)

   { return adr[i] ;                        // ici, on n'a pas prvu de 

   }                                        // vrification de la valeur de i



	 /* dfinition des fonctions amies de la classe chaine */

ostream & operator << (ostream & sortie, chaine & ch)  /* voir note  */

   { sortie << ch.adr ;

     return sortie ;

   }

chaine operator + (const chaine & ch1, const chaine & ch2)  /* voir note  */

   { chaine res ;                              

     res.lg = ch1.lg + ch2.lg ;

     res.adr = new char [res.lg+1] ;

     strcpy (res.adr, ch1.adr) ;

     strcpy (res.adr+ch1.lg, ch2.adr) ;  

     return res ;

   }







	 /* programme d'essai */

#include "chaine.h"

#include <iostream>  // voir N.B. du paragraphe "nouvelles possibilits

                     // d'entres-sorties du chapitre II

using namespace std ;

main()

{ chaine a ;

     cout << "chaine a : " << a << " de longueur " << a.length() << "\n" ;

  chaine b("bonjour") ;

     cout << "chaine b : " << b << "\n" ;

  chaine c=b ;

     cout << "chaine c : " << c << "\n" ;

  chaine d("hello") ;

  a = b = d ;

     cout << "chaine b : " << b << " de longueur " << b.length() << "\n" ;

     cout << "chaine a : " << a << "\n" ;

     cout << "a == b   : " << (a == b) << "\n" ;

  chaine x("salut "), y("chre "), z("madame");

  a = x + y + z ; 

     cout << "chaine a : " << a << "\n" ;

  a = a ; 

     cout << "chaine a : " << a << "\n" ;

  a = a + " - Comment allez-vous ?\n" ;

     cout << "chaine a : " << a ;

  a = "*****" + a ;  

     cout << "chaine a : " << a ;

// a = "bon" + "jour" ;    // serait rejet ici en compilation

  chaine e("xxxxxxxxxx") ;

  for (char cr='a', i=0 ; cr<'f' ; cr++, i++ ) e[i] = cr ;

     cout << "chaine e : " << e << "\n" ;  

}                  



