-- type abstrait simple
-- DROP TABLE personne ;
-- DROP TYPE  emolument ;
CREATE TYPE emolument
AS ( salaire  EURO ,
     prime    EURO ,
     bonus    EURO )
MODE DB2SQL 
WITH FUNCTION ACCESS  INSTANTIABLE
;
CREATE TABLE personne
   ( numemp   INTEGER NOT NULL ,
     nom      VARCHAR (30) ,
     prenom   VARCHAR (20) ,
     numsec   CHAR (13) ,
     coef     DECIMAL(3) ,
     paie     emolument )
;
-- type abstrait enclav avec mthode
-- DROP TABLE metalx1 ;
-- DROP TYPE  form_metal ;
-- DROP FUNCTION decode ;
CREATE TYPE form_metal
       AS ( lib_metal VARCHAR (20)  ,
            formule   VARCHAR (600) )
WITHOUT COMPARISONS  NOT FINAL
MODE DB2SQL
METHOD show ( form_metal )
       RETURNS VARCHAR(4023)
       LANGUAGE SQL  DETERMINISTIC  
       NO EXTERNAL ACTION 
;
CREATE TABLE metalx1
     ( no_metal     INTEGER not null,
       type_metal   VARCHAR (20) ,
       metal        form_metal ) 
;
CREATE FUNCTION decode ( VARCHAR(600) ) RETURNS VARCHAR(4000)
       EXTERNAL NAME
          'F:\sqllib\function\unfenced\metal!decode'
       LANGUAGE C  PARAMETER STYLE DB2SQL
       DETERMINISTIC  NOT FENCED  RETURNS NULL ON NULL INPUT
       NO SQL  NO EXTERNAL ACTION  ALLOW PARALLEL 
;
CREATE METHOD show (a form_metal)
       RETURNS VARCHAR(4023)
       FOR form_metal
       RETURN RTRIM(a..lib_metal) || ' : ' || decode(a..formule) 
;
CREATE FUNCTION f_show (a form_metal)
       RETURNS VARCHAR(4023) LANGUAGE SQL DETERMINISTIC
       RETURN RTRIM(a..lib_metal) || ' : ' || decode(a..formule) 
;
CREATE TRANSFORM FOR form_metal 
       db2_program 
      ( FROM SQL WITH FUNCTION f_show ) 
;
