/*-----------------------------------------------------------------*/
/* PURPOSE: slection table db2.tarecc base DBTEST                 */
/*                                                                 */
/* ODBC CLI APIs SHOWN:                                            */
/*          SQLPrepare()                SQLExecute()               */
/*          SQLAllocHandle()            SQLSetEnvAttr()            */
/*          SQLConnect()                SQLDisconnect()            */
/*          SQLBindCol()                SQLFetch()                 */
/*          SQLFreeHandle()                                        */
/*                                                                 */
/*-----------------------------------------------------------------*/
// Include The Appropriate Header Files
#include <stdio.h>
#include <windows.h>
#include <sqlcli1.h>
#include <iostream.h>
// Define The CLI_Class Class
class CLI_Class
{
    // Attributes
    public:
        SQLHANDLE  EnvHandle;
        SQLHANDLE  ConHandle;
        SQLHANDLE  StmtHandle; 
        SQLRETURN  rc;
    // Operations
    public:
        CLI_Class();                        // Constructor
        ~CLI_Class();                       // Destructor
        SQLRETURN ShowResults();
};
// Define The Class Constructor
CLI_Class::CLI_Class()
{
    // Initialize The Return Code Variable
    rc = SQL_SUCCESS;
    // Allocate An Environment Handle
    rc = SQLAllocHandle(SQL_HANDLE_ENV, SQL_NULL_HANDLE, &EnvHandle);
    // Set The ODBC Application Version To 3.x
    if (rc == SQL_SUCCESS)
        rc = SQLSetEnvAttr(EnvHandle, SQL_ATTR_ODBC_VERSION, 
                 (SQLPOINTER) SQL_OV_ODBC3, SQL_IS_UINTEGER);
    // Allocate A Connection Handle
    if (rc == SQL_SUCCESS)
        rc = SQLAllocHandle(SQL_HANDLE_DBC, EnvHandle, &ConHandle);
}
// Define The Class Destructor
CLI_Class::~CLI_Class()
{
    // Free The Connection Handle
    if (ConHandle != NULL)
        SQLFreeHandle(SQL_HANDLE_DBC, ConHandle);
    // Free The Environment Handle
    if (EnvHandle != NULL)
        SQLFreeHandle(SQL_HANDLE_ENV, EnvHandle);
}
// Define The ShowResults() Member Function
SQLRETURN CLI_Class::ShowResults(void)
{
    // Declare The Local Memory Variables
    SQLCHAR   Service[5];
    SQLCHAR   Libelle_long[26];
    // Bind The Columns In The Result Data Set Returned To
    // Application Variables
    rc = SQLBindCol(StmtHandle, 1, SQL_C_CHAR, (SQLPOINTER) 
             Service, sizeof(Service), NULL);
    rc = SQLBindCol(StmtHandle, 2, SQL_C_CHAR, (SQLPOINTER)
             Libelle_long, sizeof(Libelle_long), NULL);
    // Display A Header
    printf ( " table db2.tarecc : \n\n" );
    // While There Are Records In The Result Data Set Generated,
    // Retrieve And Display Them
    while (rc != SQL_NO_DATA)
    {
        rc = SQLFetch(StmtHandle);
        if (rc != SQL_NO_DATA)
            printf ( "service= %s - libelle= %s \n\n", Service, Libelle_long );
    }

    // Return The CLI API Return Code To The Calling Function 
    return(rc);
}
/*-----------------------------------------------------------------*/
/* The Main Function                                               */
/*-----------------------------------------------------------------*/
int main(int argc, char *argv[])
{
    // Declare The Local Memory Variables
    SQLRETURN  rc = SQL_SUCCESS;
    SQLCHAR    SQLStmt[255];
    char dbname[9];
    char userid[9];
    char passwd[19];
    // Create An Instance Of The CLI_Class Class
    CLI_Class  Example;
    printf ( "\nConnect database \n\n" );
    // Connect To The DB2 Sample Database
    if (argc == 1) {
       strcpy (dbname, "DBTEST");
       strcpy (userid, "db2");
       strcpy (passwd, "??????");
    }
    else if (argc == 2) {
       strcpy (dbname, argv[1]);
       strcpy (userid, "db2");
       strcpy (passwd, "??????");
    }
    else if (argc == 4) {
       strcpy (dbname, argv[1]);
       strcpy (userid, argv[2]);
       strcpy (passwd, argv[3]);
    }
    else {
       printf ("\nUSAGE: odbcli [ dbname [userid passwd] ]\n\n");
       return 1;
    } /* endif */
    if (Example.ConHandle != NULL)
    {
        rc = SQLConnect(Example.ConHandle, (SQLCHAR *) dbname,
                 SQL_NTS, (SQLCHAR *) userid, SQL_NTS,
                 (SQLCHAR *) passwd, SQL_NTS);
        // Allocate An SQL Statement Handle
        rc = SQLAllocHandle(SQL_HANDLE_STMT, Example.ConHandle,
                 &Example.StmtHandle);
        if (rc == SQL_SUCCESS)
        {
            // Define A SELECT SQL Statement
            strcpy((char *) SQLStmt, "SELECT service, libelle_long ");
            strcat((char *) SQLStmt,   "FROM db2.tarecc");
            // Prepare The SQL Statement
            rc = SQLPrepare(Example.StmtHandle, SQLStmt, SQL_NTS);
            // Execute The SQL Statement
            rc = SQLExecute(Example.StmtHandle);
            // Display The Results Of The SQL Query
            if (rc == SQL_SUCCESS)
                Example.ShowResults();
            // Free The SQL Statement Handle
            if (Example.StmtHandle != NULL)
                SQLFreeHandle(SQL_HANDLE_STMT, Example.StmtHandle);
        }
        // Disconnect From The DB2 Sample Database
        rc = SQLDisconnect(Example.ConHandle);
    }
    printf ( "Fin programme \n\n" );
    // Return To The Operating System
    return(rc);
}
