/**
 * JDBC Stored Procedure DB2.CALIVFRS
 */
import java.sql.*;                   // JDBC classes

public class CALIVFRS
{
    public static void cALIVFRS ( String fournisseur,
                                  int[] qte,
                                  int[] ca_livr,
                                  ResultSet[] rs ) throws SQLException, Exception
    {
        // Get connection to the database
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement stmt = null;
        String sql;

        sql = "SELECT no_four,"
            + "        sum(qte), sum(qte * px_ht)"
            + "   FROM db2.talivr L,"
            + "        db2.taprod P"
            + "  WHERE P.no_prod = L.no_prod"
            + "    AND no_four =  ? "
            + "  GROUP BY no_four";
        stmt = con.prepareStatement( sql );
        stmt.setString( 1, fournisseur );
        rs[0] = stmt.executeQuery();
        if (con != null) con.close();

        // Set return parameters
        qte[0] = qte[0];
        ca_livr[0] = ca_livr[0];
    }
}