/* ****************************************************************************
** PURPOSE: insert fichier en colonne BLOB dans table db2.tablob
**************************************************************************** */
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlenv.h>
#include <sqlutil.h>
// Fonctions JPicart
SHORT ProcessSQLError( CHAR * );
EXEC SQL INCLUDE SQLCA;
int main(int argc, char *argv[]) {
short s_Retour = 0;
   EXEC SQL BEGIN DECLARE SECTION;
      SQL TYPE IS BLOB_FILE photo;
      short no_photo;
      short no_null;
	  char  dbname[9];
      char  userid[9];
      char  passwd[19];
      char  format[4];
      char  file[41];
   EXEC SQL END DECLARE SECTION;
   printf( "\n Sample C program: insblob\n\n\n" );
   if (argc == 2) {
      strcpy (file,   argv[1]);
      EXEC SQL CONNECT TO DBTEST;
	  s_Retour = ProcessSQLError( "CONNECT TO DBTEST");
   }
   else if (argc == 3) { 
      strcpy (file,   argv[1]);
      strcpy (dbname, argv[2]);
      EXEC SQL CONNECT TO :dbname ;
      s_Retour = ProcessSQLError( "connexion a la base" );
   }
   else if (argc == 5) { 
      strcpy (file,   argv[1]);
      strcpy (dbname, argv[2]);
      strcpy (userid, argv[3]);
      strcpy (passwd, argv[4]);
      EXEC SQL CONNECT TO :dbname USER :userid USING :passwd;
      s_Retour = ProcessSQLError( "connexion a la base" );
   }
   else {
      printf ("\nUSAGE: insblob fichier [ dbname [userid passwd] ]\n\n");
      return 1;
   } /* endif */
   strcpy (photo.name, file);
   photo.name_length = strlen(file);
   photo.file_options = SQL_FILE_READ;
   EXEC SQL SELECT MAX(no_photo) INTO :no_photo :no_null
              FROM db2.tablob ;
   s_Retour = ProcessSQLError( "SELECT MAX");
   if ( no_null == -1)
      no_photo = 1 ;
   else
      no_photo++ ;
   strcpy (format,"jpg\0");
   EXEC SQL INSERT INTO db2.tablob (NO_PHOTO, FORMAT, PICTURE)
            VALUES(:no_photo, :format, :photo);
   s_Retour = ProcessSQLError( "INSERT INTO");
   if (s_Retour == 0)
      printf( "insertion OK du fichier: %s\n\n", file );
   /* Set file options to SQL_FILE_READ */
   EXEC SQL CONNECT RESET;
   s_Retour = ProcessSQLError( "CONNECT RESET");
   return 0;
}
/* end of program : INSBLOB.SQC */

/***************************************************************************/
/*                                                                         */
/* Traitement des erreurs SQL.                                             */
/*                                                                         */
/***************************************************************************/
SHORT ProcessSQLError( CHAR * psz_Msg )
{
SHORT SQLCodRet = (SHORT)sqlca.sqlcode;
SHORT s_Retour = 0;


switch ( sqlca.sqlcode )
   {


   case 0    :
                                       // Warning en prcompil. SQL
   case 25  :
   case 100  :
   case -204 :
      {
      return( SQLCodRet );
      }
                                       // Erreur en prcompil. SQL
   case -1   :
      {
      printf( " >>>> Erreur(s) de prcompilation SQL." );
      return( SQLCodRet );
      }

   case -532 :
      {
      printf ( "\n\n  Attention >> Problme de contrle d'I.R. en suppression." );
      break;
      }

   case -601 :
      {
      printf ( "\n\n  Attention >> Table dj cre." );
      break;
      }

   case -803 :
      {
      printf ( "\n\n  Attention >> Tentative d'insertion de ligne(s) dj existante(s)." );
      break;
      }

   default   :
      {
      printf ( "\nErreur SQL : >>> %s <<< \n", psz_Msg );

      printf ( "\nSQLCODE  : %ld ", sqlca.sqlcode );
      printf ( "\nSQLERRMC : %s  ", sqlca.sqlerrmc );
      printf ( "\nSQLERRP  : %s  ", sqlca.sqlerrp );
      printf ( "\nSQLERRD  : %ld | %ld | %ld | %ld | %ld | %ld ",
                             sqlca.sqlerrd[0], sqlca.sqlerrd[1],
                             sqlca.sqlerrd[2], sqlca.sqlerrd[3],
                             sqlca.sqlerrd[4], sqlca.sqlerrd[5] );
      printf ( "\nSQLWARN  : %c | %c | %c | %c | %c | %c ",
                             sqlca.sqlwarn[0],  sqlca.sqlwarn[1],
                             sqlca.sqlwarn[2],  sqlca.sqlwarn[3],
                             sqlca.sqlwarn[4],  sqlca.sqlwarn[6] );
      printf ( "\nSQLSTATE : %s ", sqlca.sqlstate );

      EXEC SQL ROLLBACK;

      EXEC SQL CONNECT RESET;

      exit( SQLCodRet );
      }
   }

return(0);
}

