/* static char sccsid[] = "@(#) File: 01   Version: 1.15   Changed: 95/12/01-13:20:39"; */
/******************************************************************************/
/* dmbsystm.h                                                                 */
/*                                                                            */
/*   This header file is included at the beginning of all DMB header files    */
/*   to define the portibility linkage/export macros for the header file      */
/*   prototypes.                                                              */
/*                                                                            */
/*   DMBEXPF(X) is used to declare/define a function that is exported and     */
/*              has the correct system linkage.                               */
/*                                                                            */
/*   DMBEXPD(X) is used to declare/define a variable that is exported and     */
/*              has the correct system linkage.                               */
/*                                                                            */
/*   DMBMAIN(X) is used to define the correct system linkage for the main()   */
/*              function of a program.                                        */
/*                                                                            */
/* Who  Name                                                                  */
/* ---  ----                                                                  */
/* JLK  James Keesey                                                          */
/*                                                                            */
/*   Date   Who Description                                                   */
/* -------- --- -----------                                                   */
/* 95/10/18 JLK Created                                                       */
/* 96/01/10 EK  modified WNT settings                                         */
/* 96/07/03 Xiaoming Zhu added WIN32 and STATIC settings                      */
/* 96/10/24 Xiaoming Zhu redefined                                            */
/*           DMBEXPHCONSTRUCT, DMBEXPHMEMBER                                  */
/*           DMBEXPCCONSTRUCT, DMBEXPCMEMBER                                  */
/*          in _MSC_VER to allow dll to be built with MS Visual C++           */
/*                                                                            */
/* 97/07/11 Myron Flickner - make the qbic api engine not use sqlsystm.h      */
/*                                                                            */
/******************************************************************************/
#ifndef DMBSYSTMH
#define DMBSYSTMH

#ifndef NO_DB2
#include <sqlsystm.h>
#endif

/* Temporary */
#if !defined(Export)
#define Export
#endif

#define DMBEXPHD                                        DMBEXPHDATA
#define DMBEXPCD                                        DMBEXPCDATA
#define DMBEXPHP                                        DMBEXPHMEMBER
#define DMBEXPCP                                        DMBEXPCMEMBER
#define DMBEXPHF                                        DMBEXPHCFUNC
#define DMBEXPCF                                        DMBEXPCCFUNC

/******************************************************************************/
/*                                                                            */
/* Macros based on a specific compiler.                                       */
/*                                                                            */
/******************************************************************************/
/*--------------------------------------------------------------------CSet++--*/
#if defined(__xlC__) || defined(_AIX32) || defined(__GNUC__) || defined(STATIC) || defined(DMB_HP) || defined(DMB_SUN)
#define DMB_COMP_CSET

#define DMBEXPHCLASS(C)         C
#define DMBEXPHCONSTRUCT
#define DMBEXPHCFUNC(X)         X SQL_API_FN
#define DMBEXPHCPPFUNC(X)               X
#define DMBEXPHMEMBER(X)                X
#define DMBEXPHDATA(X)                  X

#define DMBEXPCCLASS(C)         C
#define DMBEXPCCONSTRUCT
#define DMBEXPCCFUNC(X)         X SQL_API_FN
#define DMBEXPCCPPFUNC(X)               X
#define DMBEXPCMEMBER(X)                X
#define DMBEXPCDATA(X)                  X

#define DMBMAIN(X)                              X SQL_API_FN

/*----------------------------C/C++ for MVS/ESA--or--OS/390 R2 C/C++ feature--*/
/* use of sql_api_fn seems questionable - its not for everyone */
#elif defined(DMB_MVS)
#define DMB_COMP_IBMC

#define DMBEXPHCLASS(C)         C
#define DMBEXPHCONSTRUCT
#define DMBEXPHCFUNC(X)         X SQL_API_FN
#define DMBEXPHCPPFUNC(X)               X
#define DMBEXPHMEMBER(X)                X
#define DMBEXPHDATA(X)                  X

#define DMBEXPCCLASS(C)         C
#define DMBEXPCCONSTRUCT
#define DMBEXPCCFUNC(X)         X SQL_API_FN
#define DMBEXPCCPPFUNC(X)               X
#define DMBEXPCMEMBER(X)                X
#define DMBEXPCDATA(X)                  X

#define DMBMAIN(X)                              X

/*---------------------------------------------------Microsoft Visual C++ 1.5-*/
#elif defined(DMB_WIN)
#define DMB_COMP_MSC

#define DMBEXPHCLASS(C)         __export C
#define DMBEXPHCONSTRUCT
#define DMBEXPHCFUNC(X)         X __export SQL_API_FN
#define DMBEXPHCPPFUNC(X)       X __export
#define DMBEXPHMEMBER(X)        X
#define DMBEXPHDATA(X)          X __export

#define DMBEXPCCLASS(C)         __export C
#define DMBEXPCCONSTRUCT
#define DMBEXPCCFUNC(X)         X __export SQL_API_FN
#define DMBEXPCCPPFUNC(X)       X __export
#define DMBEXPCMEMBER(X)        X
#define DMBEXPCDATA(X)          X __export

#define DMBMAIN(X)                      X _cdecl

/*------------------------------------------------------Microsoft Visual C++--*/
#elif defined(_MSC_VER)
#define DMB_COMP_MSC

#define DMBEXPHCLASS(C)         C __declspec(dllexport)
#define DMBEXPHCONSTRUCT          __declspec(dllexport)
#define DMBEXPHCFUNC(X)         __declspec(dllexport) X SQL_API_FN
#define DMBEXPHCPPFUNC(X)               __declspec(dllexport) X
#define DMBEXPHMEMBER(X)                __declspec(dllexport) X
#define DMBEXPHDATA(X)                  __declspec(dllimport) X

#define DMBEXPCCLASS(C)         C __declspec(dllexport)
#define DMBEXPCCONSTRUCT        __declspec(dllexport)
#define DMBEXPCCFUNC(X)         __declspec(dllexport) X SQL_API_FN
#define DMBEXPCCPPFUNC(X)               __declspec(dllexport) X
#define DMBEXPCMEMBER(X)                __declspec(dllexport) X
#define DMBEXPCDATA(X)                  __declspec(dllexport) X

#define DMBMAIN(X)                              X _cdecl
/*-------------------------------------------------------------VisualAge C++--*/
#elif defined(DMB_OS2) || defined(DMB_WNT)
#define DMB_COMP_VAC

#define DMBEXPHCLASS(C)         C
#define DMBEXPHCONSTRUCT
#define DMBEXPHCFUNC(X)         X SQL_API_FN
#define DMBEXPHCPPFUNC(X)               X
#define DMBEXPHMEMBER(X)                X
#ifdef DMB_WNT
#define DMBEXPHDATA(X)                  X _Import
#else
#define DMBEXPHDATA(X)                  X
#endif

#define DMBEXPCCLASS(C)         C _Export
#define DMBEXPCCONSTRUCT     _Export
#define DMBEXPCCFUNC(X)         X _Export SQL_API_FN
#define DMBEXPCCPPFUNC(X)               X _Export
#define DMBEXPCMEMBER(X)                X _Export
#define DMBEXPCDATA(X)                  X _Export

#define DMBMAIN(X)                              X
/*--------------------------------------------------------------Symantec C++--*/
#elif defined(__SC__)
#define DMB_COMP_SC

#define DMBEXPHCLASS(C)         C
#define DMBEXPHCONSTRUCT
#define DMBEXPHCFUNC(X)         X SQL_API_FN
#define DMBEXPHCPPFUNC(X)               X
#define DMBEXPHMEMBER(X)                X
#define DMBEXPHDATA(X)                  X

#define DMBEXPCCLASS(C)         C
#define DMBEXPCCONSTRUCT
#define DMBEXPCCFUNC(X)         X SQL_API_FN
#define DMBEXPCCPPFUNC(X)               X
#define DMBEXPCMEMBER(X)                X
#define DMBEXPCDATA(X)                  X

#define DMBMAIN(X)                              X

/*-------------------------------------------------------------------Unknown--*/
#else
#error "DMB: Unsupported Compiler."
#endif
/*----------------------------------------------------------------------------*/

/******************************************************************************/
/*                                                                            */
/* Macros based on a specific operating system.                               */
/*                                                                            */
/******************************************************************************/
/*-----------------------------------------------------------------AIX--------*/
#if defined(DMB_AIX) || defined(DMB_HP)
#if !defined(DMB_UNIX)
#define DMB_UNIX
#endif

#define DMB_PATH_SEP            '/'
#define MaxPathName                     1000

/*-----------------------------------------------------------------MVS--------*/
#elif defined(DMB_MVS)
#if !defined(DMB_UNIX)
#define DMB_UNIX
#endif

#define DMB_PATH_SEP            '/'   
#define MaxPathName                     1000

/*-----------------------------------------------------------------OS/2-------*/
#elif defined(DMB_OS2)
#include <os2.h>
#define DMB_PATH_SEP            '\\'
#define MaxPathName                     CCHMAXPATH

/*---------------------------------------------------------------Windows 3.1--*/
#elif defined(DMB_WIN) || defined(DMB_WNT) || defined(DMB_W95) || \
      defined(WIN32)   || defined(_MSC_VER)
#if !defined(DMB_WINDOWS)
#define DMB_WINDOWS
#endif

#define DMB_PATH_SEP            '\\'
#define MaxPathName                     1000

/*-----------------------------------------------------------------MacOs------*/
#elif defined(DMB_MAC)

#define DMB_PATH_SEP            ':'
#define MaxPathName                     1000

/*-----------------------------------------------------------------Unknown----*/
#else
#error "DMB: Unsupported Operating System"
#endif
/*----------------------------------------------------------------------------*/

#endif
