/* ***********************************************************************
** PURPOSE: agrgation sur db2.tafour et insertion db2.calivr
************************************************************************ */
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlenv.h>
#include <sqlutil.h>
// Fonctions Jrome
SHORT ProcessSQLError( CHAR *, struct sqlca * );
EXEC SQL INCLUDE SQLCA;
int main(int argc, char *argv[]) {
short s_Retour = 0;
int nb_ligne = 0 ;
   EXEC SQL BEGIN DECLARE SECTION;
      EXEC SQL INCLUDE talivr;
      EXEC SQL INCLUDE calivr;
      char  dbname[9];
      char  userid[9];
      char  passwd[19];
      short f_no_four;
      short f_no_prod;
      short f_dat_livr;
      short f_calivr;
   EXEC SQL END DECLARE SECTION;
   printf( "\nSample C program: batch \n\n\n" );
   if (argc == 1) {
      EXEC SQL CONNECT TO DBTEST;
      s_Retour = ProcessSQLError( "CONNECT TO DBTEST", &sqlca);
   }
   else if (argc == 2) { 
      strcpy (dbname, argv[1]);
      EXEC SQL CONNECT TO :dbname ;
      s_Retour = ProcessSQLError( "connexion a la base", &sqlca);
   }
   else if (argc == 4) { 
      strcpy (dbname, argv[1]);
      strcpy (userid, argv[2]);
      strcpy (passwd, argv[3]);
      EXEC SQL CONNECT TO :dbname USER :userid USING :passwd;
      s_Retour = ProcessSQLError( "connexion a la base", &sqlca);
   }
   else {
      printf ("\nUSAGE: batch [ dbname [userid passwd] ]\n\n");
      return 1;
   } /* endif */
   EXEC SQL DECLARE c1 CURSOR FOR
            SELECT    no_four, L.no_prod, dat_livr, 
                      SUM(qte) AS qte_tot, SUM( qte * px_ht)
              FROM    livraison  L, produit P
             WHERE    L.no_prod = P.no_prod
             GROUP BY GROUPING SETS ( () , (L.no_prod, dat_livr) ,
			                          (no_four, dat_livr) )
             ORDER BY 1, 2, 3 ;
   EXEC SQL OPEN c1 ;
   s_Retour = ProcessSQLError( "OPEN CURSOR", &sqlca);
   do {
      EXEC SQL FETCH c1 
               INTO :talivr.no_four :f_no_four, 
                    :talivr.no_prod :f_no_prod, 
                    :talivr.dat_livr :f_dat_livr,
                    :calivr.qte, :calivr.calivr :f_calivr ; 
      s_Retour = ProcessSQLError( "FETCH INTO", &sqlca);
      if (SQLCODE != 0) break;
      EXEC SQL INSERT INTO calivr 
               VALUES (:talivr.no_four:f_no_four, 
                       :talivr.no_prod:f_no_prod, 
                       :talivr.dat_livr:f_dat_livr, 
                       :calivr.qte, :calivr.calivr:f_calivr) ;
      s_Retour = ProcessSQLError( "INSERT INTO", &sqlca);
      if (SQLCODE != 0) break;
      nb_ligne++;
   } while ( 1 );
   printf ( "Statistiques disponibles: %lu \n\n", nb_ligne );
   EXEC SQL CLOSE c1;
   s_Retour = ProcessSQLError( "CLOSE CURSOR", &sqlca);
   EXEC SQL CONNECT RESET;
   s_Retour = ProcessSQLError( "CONNECT RESET", &sqlca);
   return 0;
}
/* end of program : BATCH.CXX */
