import java.sql.*;
import java.math.*;
public class Batch {
   static {
      try {
         Class.forName("COM.ibm.db2.jdbc.app.DB2Driver").newInstance();
      } catch (Exception e) {
         e.printStackTrace();
      }
   }
   public static void main(String argv[]) {
      Connection con = null;
      // URL = jdbc:db2:dbname
      String url = "jdbc:db2:DBTEST";
      try {
         if (argv.length == 0) {
            // connexion avec id/password par dfaut
            con = DriverManager.getConnection(url);
            }
         else if (argv.length == 2) {
            String userid = argv[0];
            String passwd = argv[1];
            // connexion avec id/password entrs par l'utilisateur
            con = DriverManager.getConnection(url, userid, passwd);
            }
         else {
            System.out.println("\nUsage: java Batch [username password]\n");
            System.exit(0);
         }
         // rcupration des donnes de la base
         Statement stmt = con.createStatement();
         int nb_ligne = 0;
         ResultSet rs =
                  stmt.executeQuery(
                  "SELECT    no_four, L.no_prod, dat_livr, "              +
			                      "SUM(qte) AS qte_tot, SUM( qte * px_ht) "     +
                    "FROM    livraison  L, produit P "                    +
                   "WHERE    L.no_prod = P.no_prod "                      +
                   "GROUP BY GROUPING SETS ( () , (L.no_prod, dat_livr), "+
                                            "(no_four, dat_livr) ) "      +
                   "ORDER BY 1, 2, 3"
                  );
         System.out.println("\nSample Java program: Batch\n");
         // display the result set
         // rs.next() faux lorsqu'il n'y a plus de ligne
         while (rs.next()) {
            String no_four  = rs.getString(1);
            String no_prod  = rs.getString(2);
            Date   dat_livr = rs.getDate(3);
            int    qte      = rs.getInt(4);
            double calivr   = rs.getDouble(5);
            nb_ligne++;
            PreparedStatement pstmt = con.prepareStatement (
                  "INSERT INTO calivr " +
                  "VALUES (?, ?, ?, ?, ?)"
                  ) ;
              pstmt.setString (1, no_four);
              pstmt.setString (2, no_prod);
              pstmt.setDate   (3, dat_livr);
              pstmt.setInt    (4, qte);
              pstmt.setDouble (5, calivr);
              pstmt.execute();
         }
         System.out.print("Statistiques disponibles: " + nb_ligne + "\n\n");
         rs.close();
         stmt.close();
         con.close();
      } catch( Exception e ) {
         //sqlCode = e.getErrorCode()            // Get SQLCODE
         //sqlState = e.getSQLState()           // Get SQLSTATE
         System.err.println(e.getMessage()) ; // Print the exception
         System.exit(1);                      // Exit
      }
   }
}
