import java.sql.*;              // JDBC classes
import java.math.*;             // BigDecimal
import COM.ibm.db2.jdbc.app.*;  // DB2 UDB JDBC classes
public class Apcli2
{
  static
  {
    try
      {
        System.out.println ();
        System.out.println ("  Java Stored Procedure Sample");
        Class.forName ("COM.ibm.db2.jdbc.app.DB2Driver").newInstance ();
      }
    catch (Exception e)
      {
        System.out.println ("\n  Error loading DB2 Driver...\n");
        e.printStackTrace ();
      }
  }
  // (1) call the requested stored procedure and display results
  public static void callStoredProc (Connection con,
                                     String name,
                                     String fournisseur) throws Exception
  {
    // -------------------------- *
    // prepare the CALL statement
    // -------------------------- *
    CallableStatement stmt;
    String sql = "Call " + name + "(?,?,?) ";
    stmt = con.prepareCall (sql);
    // ------------------------------ *
    // register the output parameters
    // ------------------------------ *
    stmt.registerOutParameter (2, Types.INTEGER);
    stmt.registerOutParameter (3, Types.INTEGER);
    // ------------------------------------- *
    // set all parameters (input and output)
    // ------------------------------------- *
    int qte = -1;
    int ca  = -1;
    stmt.setString (1, fournisseur);
    //stmt.setInt    (2, qte);
    //stmt.setInt    (3, ca);
    // ------------------------- *
    // call the stored procedure
    // ------------------------- *
    System.out.println (" ( frs : " + fournisseur + " qte : " + qte +
                          " ca : " + ca + " ) " );
    System.out.println ("\n  Calling stored procedure: " + name);
    stmt.execute ();
    System.out.println ("\n  Returned from stored procedure: " + name);
    // -------------------------- *
    // retrieve output parameters
    // -------------------------- *
    qte = stmt.getInt (2);
    ca  = stmt.getInt (3);
    // display the information returned from the stored procedure
    System.out.println ();
    System.out.println ("    fournisseur       :   " + fournisseur );
    System.out.println ();
    System.out.println ("    quantites livrees :   " + qte );
    System.out.println ();
    System.out.println ("    CA en Euros       :   " + ca  );
    System.out.println ();
    stmt.close ();
  }
  // (2) main application: .connect and call the stored procedure
  public static void main (String argv[])
  {
    Connection con = null;
    try
      {
        String url = "jdbc:db2:dbtest";
        String callName = "DB2.CALIVR";
        String mode = "fenced";
        String fournisseur = "F3";
        if (argv.length == 0) {
           // connect with default id/password
           con = DriverManager.getConnection(url);
           }
        else if (argv.length == 2) {
           String userid = argv[0];
           String passwd = argv[1];
           // connect with user-provided username and password
           con = DriverManager.getConnection(url, userid, passwd);
           }
        else {
           System.out.println("\nUsage: java Apcli2 [username password]\n");
           System.exit(0);
        }
        // call the stored procedure
        callStoredProc (con, callName, fournisseur);
        con.close ();
      }
    catch (Exception e)
      {
        try { con.close(); } catch (Exception x) { }
        e.printStackTrace ();
      }
  }
}

