// *******************************************************************
// * IBMConnMgrTest.java - test the connection manager               *
// *******************************************************************
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;
import com.ibm.servlet.connmgr.*;
public class STarecc extends HttpServlet
{
   // ****************************************************************
   // * Variables                                                    *
   // ****************************************************************
   // Use to communicate with connection manager.
   static IBMConnMgr connMgr = null;
   // Use later in init() to create JDBC connection specification.
   static IBMConnSpec spec   = null;      // the spec
   static String DbName      = null;      // database name
   static String Db          = "db2";     // JDBC subprotocol for DB2
   static String poolName    = "JdbcDb2"; // from Webmaster
   static String jdbcDriver  = "COM.ibm.db2.jdbc.app.DB2Driver";
   static String url         = null;      // constructed later
   static String user        = null;      // user and password could
   static String password    = null;      // come from HTML form
   static String owner       = null;      // table owner
   // Name of property file used to complete the user, password, dbname
   // and table owner at runtime.  ".properties" extension assumed.
   static final String CONFIG_BUNDLE_NAME = "STareccL";
   // ****************************************************************
   // * Initialize servlet when it is first loaded                   *
   // ****************************************************************
   public void init(ServletConfig config)
   throws ServletException
   {
      super.init(config);
      try
      {
         // Get information at runtime (from an external property file
         // identified by CONFIG_BUNDLE_NAME) to connect to DB
         PropertyResourceBundle configBundle =
         (PropertyResourceBundle)PropertyResourceBundle.
         getBundle(CONFIG_BUNDLE_NAME);
         DbName   = configBundle.getString("JDBCServlet.dbName");
         url      = "jdbc:" + Db + ":" + DbName;
         user     = configBundle.getString("JDBCServlet.dbUserid");
         password = configBundle.getString("JDBCServlet.dbPassword");
         owner    = configBundle.getString("JDBCServlet.dbOwner");
      }
      catch(Exception e)
      {
         System.out.println("read properties file: " + e.getMessage());
      }
      try
      {
         // *------------------------------------------------*
         // * STEP 1 = Create JDBC connection specification. *
         // *------------------------------------------------*
         spec = new IBMJdbcConnSpec
                (poolName,    // pool name from Webmaster
                 true,        // waitRetry
                 jdbcDriver,  // Remaining four
                 url,         // parameters are
                 user,        // specific for a
                 password);   // JDBC connection.
         // *-----------------------------------------------------*
         // * STEP 2 = Get a reference to the connection manager. *
         // *-----------------------------------------------------*
         connMgr = IBMConnMgrUtil.getIBMConnMgr();
      }
      catch(Exception e)
      {
         System.out.println("set connection spec, get connection manager: " +
                            e.getMessage());
      }
   }
   // ****************************************************************
   // * Respond to user GET request                                  *
   // ****************************************************************
   public void doGet(HttpServletRequest req, HttpServletResponse res)
   {
      IBMJdbcConn cmConn   = null;
      Connection dataConn  = null;
      Vector ParamList = new Vector();
      try
      {
         // *--------------------------------------------------------------*
         // * STEP 3 = Get an IBMJdbcConn object (cmConn) meeting JDBC     *
         // *          connection specs, from the connection manager pool. *
         // *--------------------------------------------------------------*
         cmConn = (IBMJdbcConn)connMgr.getIBMConnection(spec);
         // *-----------------------------------------------------------------*
         // * STEP 4 = Get a Connection object (dataConn).  This is an object *
         // *          from java.sql package and it is used for JDBC access.  *
         // *-----------------------------------------------------------------*
         dataConn = cmConn.getJdbcConnection();
         // *--------------------------------------------------------------*
         // * STEP 5 = Run DB query - create a Vector of columns of tarecc *
         // *--------------------------------------------------------------*
         Statement stmt = dataConn.createStatement();
         String query   = "SELECT service, libelle, libelle_long " +
                            "FROM " + owner + ".tarecc"  ;
         ResultSet rs   = stmt.executeQuery(query);
         while(rs.next())
         {
            ParamList.addElement(rs.getString(1));
            ParamList.addElement(rs.getString(2));
            ParamList.addElement(rs.getString(3));
         }
         // Invoke close() on stmt, which also closes rs, freeing
         // resources and completing the interaction. Do not close
         // the dataConn object.  It must remain open and under
         // the control of connection manager for possible use
         // by other requests to this servlet or to other servlets.
         stmt.close();
      }
      catch(Exception e)
      {
         System.out.println("get connection, process statement: " +
                            e.getMessage());
      }
      // *---------------------------------------------------*
      // * STEP 6 = Release the connection back to the pool. *
      // *---------------------------------------------------*
      finally
      {
         if(cmConn != null)
         {
            try
            {
               cmConn.releaseIBMConnection();
            }
            catch(IBMConnMgrException e)
            {
               System.out.println("release connection: " + e.getMessage());
            }
         }
      }
      // *-------------------------------------------*
      // * STEP 7 = Prepare and return HTML response *
      // *-------------------------------------------*
      res.setContentType("text/html");
      // Next 3 lines prevent dynamic content from being cached on browsers.
      res.setHeader("Pragma", "no-cache");
      res.setHeader("Cache-Control", "no-cache");
      res.setDateHeader("Expires", 0);
      try
      {
         ServletOutputStream out = res.getOutputStream();
         out.println("");
         out.println("<HEAD><TITLE>Hello DBTEST</TITLE><HEAD>");
         out.println("");
         out.println("<H1 align=center> Connexion JDBC via servlet </H1>");
         out.println("<BR>");
         out.println("<P><CENTER>&nbsp;<U><A HREF=\"../monsite/udbindex.htm\">Retour Menu " +
                     "</A></U></CENTER></TD>");
         out.println("<BR>");
         out.println("<BR>");
         if(ParamList.isEmpty())
         {
            out.println("<H3>(" + DbName + ") SELECT service, libelle, libelle_long " +
	                                           "FROM " + owner + ".tarecc </H3>");
            out.println("<H2>Pas de ligne rendue !!!</H2>");
         }
         else
         {
            int j = 1;
            for(int i = 0; i < ParamList.size(); i++)
            {
               out.println("<H3> ligne " + j + 
                             "  =>  service :   " + ParamList.elementAt(i) 
                           + " - " + ParamList.elementAt(++i) 
                           + " - " + ParamList.elementAt(++i)
                           + " </H3>");
               j++;
            }
         }
         out.println("");
         out.close();
      }
      catch(IOException e)
      {
         System.out.println("HTML response: " + e.getMessage());
      }
   }
}

