import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;

/*
  <APPLET
      CODE=fonts.class
      WIDTH=600
      HEIGHT=200 >
  </APPLET>
*/

public class fonts extends Applet implements ActionListener, KeyListener {

    String text = "";

    Button boldbutton, italicbutton, largebutton;
    boolean bold = false;
    boolean italic = false;
    boolean large = false;

    public void init()
    {
        boldbutton = new Button("Fonte gras");
        italicbutton = new Button("Fonte italique");
        largebutton = new Button("Grande fonte");

        boldbutton.addActionListener(this);
        italicbutton.addActionListener(this);
        largebutton.addActionListener(this);

        add(boldbutton);
        add(italicbutton);
        add(largebutton);

        addKeyListener(this);
        requestFocus();
    }

    public void actionPerformed(ActionEvent event)
    {
        if(event.getSource() == boldbutton) bold = !bold;
        if(event.getSource() == italicbutton) italic = !italic;
        if(event.getSource() == largebutton) large = !large;
        requestFocus();
        repaint();
    }

    public void paint(Graphics g)
    {
        String fontname = "Courrier";
        int type = Font.PLAIN;
        int size = 36;
        Font font;
        FontMetrics fm;

        if(bold) type = type | Font.BOLD;
        if(italic) type = type | Font.ITALIC;
        if(large) size = 72;

        font = new Font(fontname, type, size);
        g.setFont(font);

        fm = getFontMetrics(font);
        int xloc = (getSize().width - fm.stringWidth(text)) / 2;
        int yloc = (getSize().height + fm.getHeight()) / 2;

        g.drawString(text, xloc, yloc);
    }

    public void keyTyped(KeyEvent e)
    {
        text = text + e.getKeyChar();
        repaint();
    }

    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}
}
