import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;

/*
<APPLET
    CODE=FrameExample.class
    WIDTH=300
    HEIGHT=200 >
</APPLET>
*/


public class FrameExample extends Applet implements ActionListener
{
    Button b1, b2;
    LabelFrame window;

    public void init()
    {
        b1 = new Button("Afficher la fentre");
        add(b1);
        b1.addActionListener(this);

        b2 = new Button("Cacher la fentre");
        add(b2);
        b2.addActionListener(this);

        window = new LabelFrame("Fentre Java");
        window.setSize(400, 200);
    }

    public void actionPerformed(ActionEvent event)
    {
        if(event.getSource() == b1){
            window.setVisible(true);
        } 
        if(event.getSource() == b2){
            window.setVisible(false);
        }
    }
}

class LabelFrame extends Frame implements MouseListener
{
    Label label;

    LabelFrame(String title)
    {
        super(title);
        setLayout(new FlowLayout());
        label = new Label("Bien le bonjour de Java ! Voici une fentre encadre.");
        add(label);
        addMouseListener(this);
    }

    public void mousePressed(MouseEvent e)
    {
        if((e.getModifiers() & InputEvent.BUTTON1_MASK) ==
            InputEvent.BUTTON1_MASK){
            label.setText("Clic sur bouton gauche en " + e.getX() + "," +
                e.getY());
        }
        else{
            label.setText("Clic sur bouton droit en " + e.getX() + "," +
                e.getY());
        }
    }

    public void mouseClicked(MouseEvent e)
    {
        label.setText("Vous avez cliqu sur la souris en " + e.getX() + "," + 
            e.getY());
    }

    public void mouseReleased(MouseEvent e)
    {
        label.setText("Le bouton n'est plus enfonc.");
    }

    public void mouseEntered(MouseEvent e)
    {
        label.setText("Le curseur de souris est dans la fentre.");
    }

    public void mouseExited(MouseEvent e)
    {
        label.setText("Le curseur de souris est sorti de la fentre.");
    }
}

