
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

/*
<APPLET
    CODE=MenuExample2.class
    WIDTH=200
    HEIGHT=200 >
</APPLET>
*/

public class MenuExample2 extends Applet implements ActionListener
{
    Button b1;
    FrameExample menuWindow;

    public void init()
    {
        b1 = new Button("Afficher la fentre avec menu");
        add(b1);
        b1.addActionListener(this);

        menuWindow = new FrameExample("Menus");
        menuWindow.setSize(200, 200);
    }

    public void actionPerformed(ActionEvent event)
    {
        if(event.getSource() == b1){
            menuWindow.setVisible(true);
        }
    }
}

class FrameExample extends Frame implements ActionListener, ItemListener
{
    Menu menu, submenu;
    MenuBar menubar;
    Label label;
    MenuItem menuitem1, menuitem2, menuitem4;
    MenuItem subitem1, subitem2, subitem3;
    CheckboxMenuItem menuitem3;

    FrameExample(String title)
    {
        super(title);
        label = new Label("Bien le bonjour de Java !");
        setLayout(new GridLayout(1, 1));
        add(label);
        menubar = new MenuBar();
        menu = new Menu("Fichier");

        menuitem1 = new MenuItem("Option 1");
        menuitem1.addActionListener(this);
        menu.add(menuitem1);

        menuitem2 = new MenuItem("Option 2");
        menuitem2.addActionListener(this);
        menu.add(menuitem2);

        menu.addSeparator();

        menuitem3 = new CheckboxMenuItem("Option avec coche");
        menuitem3.addItemListener(this);
        menu.add(menuitem3);

        menu.addSeparator();

        submenu = new Menu("Sous-menus");
        subitem1 = new MenuItem("Sous-option 1");
        subitem2 = new MenuItem("Sous-option 2");
        subitem3 = new MenuItem("Sous-option 3");
        subitem1.addActionListener(this);
        subitem2.addActionListener(this);
        subitem3.addActionListener(this);
        menuitem2.addActionListener(this);
        menuitem2.addActionListener(this);
        submenu.add(subitem1);
        submenu.add(subitem2);
        submenu.add(subitem3);

        menu.add(submenu);

        menu.addSeparator();

        menuitem4 = new MenuItem("Quitter");
        menuitem4.addActionListener(this);
        menu.add(menuitem4);

        menubar.add(menu);
        setMenuBar(menubar);

         addWindowListener(new WindowAdapter() {public void
              windowClosing(WindowEvent e) {setVisible(false);}});
    }

    public void actionPerformed(ActionEvent event)
    {
        if(event.getSource() == menuitem1){
          label.setText("Vous avez choisi l'option 1");
        } else if(event.getSource() == menuitem2){
          menuitem2.setEnabled(false);
          label.setText("Vous avez choisi l'option 2");
        } else if(event.getSource() == subitem1){
          label.setText("Vous avez choisi la sous-option 1");
        } else if(event.getSource() == subitem2){
          label.setText("Vous avez choisi la sous-option 2");
        } else if(event.getSource() == subitem3){
          label.setText("Vous avez choisi la sous-option 3");
        } else if(event.getSource() == menuitem4){
          setVisible(false);
        }
    }

    public void itemStateChanged (ItemEvent event)
    {
         if(event.getSource() == menuitem3){
             if(((CheckboxMenuItem)event.getItemSelectable()).getState())
                 label.setText("L'option 3 est coche");
             else
                 label.setText("L'option 3 n'est pas coche");
         }
    }
}

